(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuse_weight > 0 do (
				if mtl.diff_color_map != undefined and mtl.diff_color_map_on do 
					append res #("diffuse", mtl.diff_color_map)
				if mtl.diff_rough_map != undefined and mtl.diff_rough_map_on do 
					append res #("diffuse_roughness", mtl.diff_rough_map, "resultFloat")
			)

			if mtl.refl_weight > 0 do (
				if mtl.refl_color_map != undefined and mtl.refl_color_map_on do 
					append res #("refl_color", mtl.refl_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refl_gloss", mtl.refl_gloss_map, "resultFloat")
			)

			if mtl.refr_weight > 0 do (
				if mtl.refr_color_map != undefined and mtl.refr_color_map_on do 
					append res #("refr_color", mtl.refr_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refr_gloss", mtl.refr_gloss_map, "resultFloat")

				if mtl.refr_trans_on do (
					if mtl.refr_transc_map != undefined and mtl.refr_transc_map_on do 
						append res #("refr_transc", mtl.refr_transc_map)
					if mtl.refr_transw_map != undefined and mtl.refr_transw_map_on do 
						append res #("refr_transw", mtl.refr_transw_map, "resultFloat")
				)
			)

			if mtl.refr_ior_map != undefined and mtl.refr_ior_map_on do 
				append res #("refr_ior", mtl.refr_ior_map, "resultFloat")

			if mtl.bump_map != undefined and mtl.bump_map_on do 
				append res #("normal_perturb", mtl.bump_map, "normalPerturb", 1)

			if mtl.self_illum_on and mtl.self_illum_map != undefined and mtl.self_illum_map_on do 
				append res #("emission_filter", mtl.self_illum_map)
			if mtl.cutout_map != undefined and mtl.cutout_map_on do 
				append res #("cutout_opacity", mtl.cutout_map, "resultFloat")

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do 
				append res #("additional_color", mtl.add_color_map)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse",           mtl.diff_color)
			append res #("diffuse_weight",    mtl.diff_weight)
			append res #("diffuse_roughness", mtl.diff_rough)

			if mtl.refl_weight > 0 do (
				append res #("reflectivity",      mtl.refl_weight)

				append res #("refl_use_ior",      mtl.refl_func_fresnel)
				append res #("refl_exponent",     mtl.refl_func_curve)
				append res #("refl_curve_low",    mtl.refl_func_low)
				append res #("refl_curve_high",   mtl.refl_func_high)

				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_gloss)
				append res #("refl_is_metal",     mtl.refl_metal)
				append res #("anisotropy",        mtl.anisotropy)
			)

			append res #("thin_walled",       mtl.opts_1sided)

			if mtl.refr_weight > 0.0 do (
				append res #("transparency",      mtl.refr_weight) 
				append res #("refr_color",        mtl.refr_color)
				append res #("refr_gloss",        mtl.refr_gloss)

				if mtl.refr_trans_on do (
					append res #("refr_transc",  mtl.refr_transc)
					append res #("refr_transw",  mtl.refr_transw)
				)
			)

			append res #("refr_ior",          mtl.refr_ior)

			if mtl.self_illum_on do (
				append res #("emission_filter",       mtl.self_illum_color_filter)

				if mtl.self_illum_int_mode then
				(
					local x = mtl.self_illum_int_arbitrary * 256
					append res #("emission",  (color x x x ))
				)
				else
				(
					-- TODO: THIS IS NOT EXACT, we need to get the physical scale from max some other way
					-- because this doesn't take the "mode" into account of the Physical Camera ....
					local physical_scale = 1500

					local p = SceneExposureControl.exposureControl

					if p != undefined do (
						physical_scale = p.physical_scale
					)

					local x = mtl.self_illum_int_physical * 3.1415 / physical_scale * 256
					append res #("emission",  (color x x x ))
				)

				append res #("att:emissive", true)
			)

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do (
				append res #("att:emissive", true) 
			)

			append res #("no_diffuse_bump",  mtl.no_diffuse_bump)

			append res #("bump_amount",  mtl.bump_map_amt * -1.0)

			append res #("cutout_opacity", 1.0) -- default to Opaque

			res
		)
	)

	AMGData()	
)
